/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.event;

import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.event.IVWCoordinationEventListener;
import filenet.vw.toolkit.design.property.event.VWCoordinationEvent;
import javax.swing.event.EventListenerList;

public class VWCoordinationEventNotifier {
    private EventListenerList m_coordinationListeners = null;

    public void addCoordinationEventListener(IVWCoordinationEventListener listener) {
        if (this.m_coordinationListeners == null) {
            this.m_coordinationListeners = new EventListenerList();
        }
        this.removeCoordinationEventListener(listener);
        this.m_coordinationListeners.add(IVWCoordinationEventListener.class, listener);
    }

    public void removeCoordinationEventListener(IVWCoordinationEventListener listener) {
        if (this.m_coordinationListeners != null) {
            this.m_coordinationListeners.remove(IVWCoordinationEventListener.class, listener);
        }
    }

    public void sendCoordinationEvent(Object source, int nId, Object eventParam) {
        VWCoordinationEvent event = new VWCoordinationEvent(source, nId, eventParam);
        this.sendCoordinationEvent(event);
    }

    public void sendCoordinationEvent(VWCoordinationEvent event) {
        try {
            if (event != null && this.m_coordinationListeners != null && this.m_coordinationListeners.getListenerCount() > 0) {
                Object[] listeners = this.m_coordinationListeners.getListenerList();
                for (int i = listeners.length - 2; i >= 0; i -= 2) {
                    if (listeners[i] != IVWCoordinationEventListener.class) continue;
                    ((IVWCoordinationEventListener)listeners[i + 1]).handleCoordinationEvent(event);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void releaseReferences() {
        this.m_coordinationListeners = null;
    }
}

